/* euler.cpp */

#include "fp.h"


static void euler(fp& res)
{
	INT32		userPrecision, bitPrecision;
	fp			dx, dx2, ten, one, temp, tenPower, small;
	
	INT32 p = getBlockPrec();
	setBlockPrec(p+p/4);
	
	one = 1;
	ten = 10;
	
	bitPrecision = blockBits*p;
	userPrecision = bitPrecision/5;
	tenPower = 2.09*userPrecision/5;
	pow(dx, ten, -tenPower);
	
	Gamma(temp, one + dx);
	small = temp;
	
	Gamma(temp, one - dx);
	small = small - temp;
	
	dx2 = 2*dx;
	
	Gamma(temp, one + dx2);
	res = - temp/8;
	
	Gamma(temp, one - dx2);
	res = res + temp/8;
	
	res = small + res;
	
	res = -2*res/(3*dx);
	
	setBlockPrec(p);
	
}/* euler */

// Euler's Constant
void EulerGamma(fp& z)
{
	static fp		gamma;
	static bool		initGood=false;
	static INT32	p, blockPrecCurr;
	
	if(!initGood)
	{
		blockPrecCurr = 0;
		initGood = true;
	}
	
	p = getBlockPrec();
	
	if(p<=blockPrecCurr)
	{
		equate(z, gamma);
		fpNormalize(z);
		return;
	}
	
	blockPrecCurr = p;
	
	euler(z);
	
	equate(gamma, z);
	
}/* EulerGamma */


fp EulerGamma()
{
	fp		z;
	
	EulerGamma(z);
	
	return z;
	
}/* EulerGamma */